require( "scripts/style.lua" );

NameFont = {
  standardFont,
  20,
  BlackColor
};

HeaderFont = {
  standardFont,
  48,
  BlackColor
};

ButtonX = kCenter;
ButtonY = 90;
ButtonYSpace = 30;


MapButtonGraphics = {
	"images/button_heart.png",
	"images/button_heart.png",
	"images/button_heart.png",
	"images/button_heart.png"
};	

MapStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = NameFont,
	graphics = MapButtonGraphics,
	sound = kDefaultButtonSound
};


MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/dialog",
		x = kCenter,y = kCenter,w = kMax,h = kMax,
		
		PauseMenu
		{
			x = kCenter, y = kCenter, w=kMax, h=kMax,
			Text
			{
				font = HeaderFont,
				name = "pauselevel",
				x=0,y=150,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "ui.dialog.pause.title"
			};
			
			SetStyle(MapStyle);
			
			-- RESUME
			Button
			{
				x=280,
				y=210,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="resume",
				label="ui.dialog.pause.resume.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						PopModal();
						PauseAction(1700);
					end
				
			};
			
			-- OPTIONS
			Button
			{
				x=410,
				y=210,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="options",
				label="ui.dialog.options.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						DoModal("scripts/options.lua");
					end	
			};
			
			
			
			-- HELP
			Button
			{
				x=280,
				y=288,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="help",
				label="ui.dialog.help.title",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						DoModal("scripts/helpmenu1.lua");
					end
				
			};
			
			-- RESTART LEVEL
			Button
			{
				x=410,
				y=288,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="restart",
				label="ui.dialog.restartlevel.title",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						currentVenue = CurrentVenue();
						currentLevel = CurrentLevel();
						RestartLevel(currentLevel,currentVenue);	-- tell the metamap we want to replay this level immediately
						PopModal(); -- pop pause menu
						PopModal(); -- pop this level
					end	
			};
			
			
			-- METAMAP
			Button
			{
				x=280,
				y=365,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="metamap",
				label="common.metamap.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					result = 
						DisplayDialog
						{ 
							"scripts/yesno.lua",
							body ="ui.dialog.metamap.confirm",
							title = "ui.dialog.metamap.title" 
						};
						if (result=='yes') then
							PopModal(); -- pop this box
							PauseAction(1701);
							
						end
					end	
			};
			
			-- QUIT
			Button
			{
				x=410,
				y=365,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="quit",
				label="common.quit.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						result = 
						DisplayDialog
						{ 
							"scripts/yesno.lua",
							body ="ui.dialog.mainmenu.confirm",
							title = "ui.dialog.mainmenu.title" 
						};
						if (result=='yes') then
							PopModal(); -- pop this box
							PauseAction(1704);
						end
					end				
			};
				
				
		}
	}
}